package ru.yandex.chemodan.app.telemost.services;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.dao.UserTokenDtoDao;
import ru.yandex.chemodan.app.telemost.repository.model.UserTokenDto;
import ru.yandex.chemodan.app.telemost.repository.model.UserTokenStatus;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;
import ru.yandex.chemodan.app.telemost.util.UUIDUtils;
import ru.yandex.commune.dynproperties.DynamicProperty;

public class UserTokenService {

    public static final long DEFAULT_USER_TOKEN_TTL_SECS = 600L;

    private final UserTokenDtoDao userTokenDtoDao;

    private final DynamicProperty<Long> tokenExpirationPeriodInSecs =
            new DynamicProperty<>("telemost-yateam-token-expiration-period-secs", DEFAULT_USER_TOKEN_TTL_SECS);

    public UserTokenService(UserTokenDtoDao userTokenDtoDao) {
        this.userTokenDtoDao = userTokenDtoDao;
    }

    public String createUserToken(UUID conferenceId) {
        UserTokenDto userTokenDto = new UserTokenDto(Option.empty(), Option.empty(), conferenceId, generateToken(),
                Instant.now(), UserTokenStatus.CREATED.name());
        return userTokenDtoDao.insert(userTokenDto).getToken();
    }

    public Option<UserTokenDto> getActivatedOrActivateToken(UUID conferenceId, PassportOrYaTeamUid uid, String token) {
        return userTokenDtoDao.getActiveOrUpdateCreatedToken(conferenceId, uid.asString(), token, tokenExpirationPeriodInSecs.get());
    }

    public Option<UserTokenDto> getCreatedOrActiveToken(UUID conferenceId, PassportOrYaTeamUid uid, String token) {
        return userTokenDtoDao.getToken(conferenceId, uid.asString(), token, tokenExpirationPeriodInSecs.get());
    }

    private String generateToken() {
        return UUIDUtils.generateUUIDHex();
    }
}
