package ru.yandex.chemodan.app.telemost.services;

import ru.yandex.chemodan.xiva.XivaSecretSign;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.io.http.UriBuilder;

public class WebsocketUriService {

    private final String baseUrl;

    private final String serviceName;

    private final DynamicProperty<String> client = new DynamicProperty<>("telemost-xiva-websocket-client", "telemost");

    private final DynamicProperty<Integer> fetchHistoryCount = new DynamicProperty<>("telemost-xiva-websocket-fetch-count", 1);

    public WebsocketUriService(String baseUrl, String serviceName) {
        this.baseUrl = baseUrl;
        this.serviceName = serviceName;
    }

    public String buildWebsocketUri(XivaSecretSign secretSign, String user, String sessionId) {
        UriBuilder uriBuilder = new UriBuilder()
                .setScheme("wss")
                .setHost(baseUrl)
                .appendPath("v2/subscribe/websocket")
                .addParam("service", serviceName)
                .addParam("user", user)
                .addParam("client", client.get())
                .addParam("session", sessionId)
                .addParam("sign", secretSign.getSign())
                .addParam("ts", secretSign.getTs());
        return uriBuilder.build().toASCIIString();
    }
}
