package ru.yandex.chemodan.app.telemost.services;

import java.util.function.Supplier;

import ru.yandex.chemodan.app.telemost.services.model.ConferenceClientParameters;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;
import ru.yandex.chemodan.app.telemost.services.model.User;

public class YaTeamConferenceCreator extends DefaultConferenceCreator {
    public YaTeamConferenceCreator(Supplier<String> conferencePasswordProvider,
            ConferenceUriService conferenceUriService)
    {
        super(conferencePasswordProvider, conferenceUriService);
    }

    @Override
    public boolean isAcceptableFor(ConferenceClientParameters clientParameters) {
        return clientParameters.getUser().map(User::getUid).map(PassportOrYaTeamUid::isYaTeamUid).getOrElse(Boolean.FALSE) &&
                !clientParameters.getExternalMeeting().getOrElse(Boolean.FALSE);
    }

    @Override
    protected Boolean getDefaultIsPermanentValue() {
        return Boolean.TRUE;
    }

    @Override
    protected boolean isYaTeam() {
        return true;
    }
}
