package ru.yandex.chemodan.app.telemost.services.model;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.BroadcastDto;

@Data
public class Broadcast {

    private final BroadcastDto broadcast;

    private final String uri;

    private final Option<String> chatPath;

    public static Broadcast withChatPath(Broadcast broadcast, Option<String> chatPath) {
        return new Broadcast(
                broadcast.getBroadcast(),
                broadcast.getUri(),
                chatPath
        );
    }

}
