package ru.yandex.chemodan.app.telemost.services.model;

import lombok.Data;

import ru.yandex.bolts.collection.Option;

@Data
public class BroadcastUserId {

    private final Option<PassportOrYaTeamUid> uid;
    private final Option<String> translatorToken;

    public static BroadcastUserId user(PassportOrYaTeamUid uid) {
        return new BroadcastUserId(Option.of(uid), Option.empty());
    }

    public static BroadcastUserId translator(String token) {
        return new BroadcastUserId(Option.empty(), Option.of(token));
    }

    public static BroadcastUserId anonymous() {
        return new BroadcastUserId(Option.empty(), Option.empty());
    }
}
