package ru.yandex.chemodan.app.telemost.services.model;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.exceptions.YaTeamTokenAccessDeniedTelemostException;
import ru.yandex.chemodan.app.telemost.repository.model.ConferenceDto;
import ru.yandex.chemodan.app.telemost.services.UserTokenService;

public enum CheckUserTokenPolicy {

    DEFAULT {
        @Override
        public boolean checkToken(UserTokenService userTokenService, Option<User> user,
                ConferenceUriData conferenceUriData, ConferenceDto conference) {
            return userTokenService.getActivatedOrActivateToken(
                    conference.getId(),
                    user.map(User::getUid).getOrThrow(YaTeamTokenAccessDeniedTelemostException::new),
                    conferenceUriData.getUserToken().getOrThrow(YaTeamTokenAccessDeniedTelemostException::new)
            ).isPresent();
        }
    },
    JUST_CHECK_EXIST {
        @Override
        public boolean checkToken(UserTokenService userTokenService, Option<User> user,
                ConferenceUriData conferenceUriData, ConferenceDto conference) {
            return userTokenService.getCreatedOrActiveToken(
                    conference.getId(),
                    user.map(User::getUid).getOrThrow(YaTeamTokenAccessDeniedTelemostException::new),
                    conferenceUriData.getUserToken().getOrThrow(YaTeamTokenAccessDeniedTelemostException::new)
            ).isPresent();
        }

    };

    public abstract boolean checkToken(UserTokenService userTokenService, Option<User> user,
            ConferenceUriData conferenceUriData, ConferenceDto conference);
}
