package ru.yandex.chemodan.app.telemost.services.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ClientConfiguration {

    @JsonProperty("v1")
    private Option<MapF<String, Object>> v1 = Option.empty();

    @JsonProperty("v2")
    private Option<MapF<String, Object>> v2 = Option.empty();

    private final MapF<String, Object> data = Cf.hashMap();

    @JsonAnyGetter
    public Map<String, Object> getData() {
        return this.data;
    }

    @JsonAnySetter
    public void addDataField(String field, Object value) {
        this.data.put(field, value);
    }
}
