package ru.yandex.chemodan.app.telemost.services.model;

import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.Option;

@Data
@Builder
public class ConferenceClientParameters {

    private final Option<User> user;

    private final Option<Boolean> staffOnly;

    private final Option<Boolean> permanent;

    private final XMPPLimitType limitType;

    private final Option<Boolean> externalMeeting;

    private final Option<String> eventId;

    public ConferenceClientParameters withLimitType(XMPPLimitType limitType) {
        return new ConferenceClientParameters(this.user, this.staffOnly, this.permanent, limitType, this.externalMeeting,
                this.eventId);
    }
}
