package ru.yandex.chemodan.app.telemost.services.model;

import java.util.UUID;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.ConferenceDto;
import ru.yandex.chemodan.app.telemost.repository.model.ConferenceStateDto;
import ru.yandex.chemodan.app.telemost.services.ConferenceService;
import ru.yandex.chemodan.app.telemost.web.v2.model.BroadcastStateData;
import ru.yandex.misc.lang.DefaultObject;

public class ConferenceState extends DefaultObject {
    private final ConferenceStateDto conferenceState;

    public ConferenceState(ConferenceService conferenceService, ConferenceDto conference) {
        boolean isStaffOwner = conferenceService.isStaffOwner(conference);

        this.conferenceState = new ConferenceStateDto(
                conferenceService.isLocalRecordingAllowed(),
                conferenceService.isCloudRecordingAllowed(),
                conferenceService.isChatsAllowed(conference, isStaffOwner),
                Option.empty(),
                conferenceService.isControlAllowed(conference, isStaffOwner),
                conferenceService.isBroadcastAllowed(conference, isStaffOwner),
                conferenceService.isBroadcastFeatureEnabled(conference),
                Option.empty(),
                Option.empty(),
                conference.getId()
        );
    }

    public ConferenceState(ConferenceStateDto conferenceStateDto) {
        this.conferenceState = conferenceStateDto;
    }

    public UUID getConferenceId() {
        return conferenceState.getConferenceId();
    }

    public long getVersion() {
        return conferenceState.getVersion();
    }

    public boolean isLocalRecordingAllowed() {
        return conferenceState.isLocalRecordingAllowed();
    }

    public boolean isCloudRecordingAllowed() {
        return conferenceState.isCloudRecordingAllowed();
    }

    public boolean isChatAllowed() {
        return conferenceState.isChatAllowed();
    }

    public boolean isControlAllowed() {
        return conferenceState.isControlAllowed();
    }

    public boolean isBroadcastAllowed() {
        return conferenceState.isBroadcastAllowed();
    }

    public boolean isBroadcastFeatureEnabled() {
        return conferenceState.isBroadcastFeatureEnabled();
    }

    public Option<String> getChatPath() {
        return conferenceState.getChatPath();
    }

    public Option<BroadcastStateData> getBroadcast() {
        if (conferenceState.getBroadcast().isEmpty()) {
            return Option.empty();
        }
        return Option.of(new BroadcastStateData(conferenceState.getBroadcast().get(), conferenceState.getStream()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof ConferenceState)) {
            return false;
        }

        ConferenceState obj = (ConferenceState) o;
        return getConferenceId().equals(obj.getConferenceId())
                && getVersion() == obj.getVersion()
                && isLocalRecordingAllowed() == obj.isLocalRecordingAllowed()
                && isCloudRecordingAllowed() == obj.isCloudRecordingAllowed()
                && isChatAllowed() == obj.isChatAllowed()
                && isBroadcastAllowed() == obj.isBroadcastAllowed()
                && isBroadcastFeatureEnabled() == obj.isBroadcastFeatureEnabled();
    }
}
