package ru.yandex.chemodan.app.telemost.services.model;

import java.util.function.Consumer;

import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.MediaSessionDto;

@Data
@Builder
public class CreateSessionData {

    private final Option<String> sessionId;

    private final UserDetails userDetails;

    private final Conference conference;

    private final ParticipantsData participantsData;

    private final Option<User> user;

    private final Option<MediaSessionDto> deactivatedSession;

    private final Option<String> clientInstanceId;

    private final Consumer<String> peerIdProcessor;

    public Option<String> getUidAsString() {
        return user.map(User::getUid).map(PassportOrYaTeamUid::asString);
    }

    public CreateSessionData withDeactivatedSession(MediaSessionDto deactivatedSession) {
        return new CreateSessionData(sessionId, userDetails, conference, participantsData, user,
                Option.of(deactivatedSession), clientInstanceId, peerIdProcessor);
    }

    public CreateSessionData withSessionId(String sessionId) {
        return new CreateSessionData(Option.of(sessionId), userDetails, conference, participantsData, user,
                deactivatedSession, clientInstanceId, peerIdProcessor);
    }
}
