package ru.yandex.chemodan.app.telemost.services.model;

import java.net.URI;

import org.joda.time.Duration;

import ru.yandex.inside.logbroker.pull.consumer.LbConsumerSettings2;
import ru.yandex.inside.logbroker.pull.model.LbTopicFilter;

public class LbPassportConsumerSettings2Impl extends LbConsumerSettings2 {
    final private int listenerMaxQueueSize;
    final private URI lbBaseUrl;
    final private String lbClientId;
    final private int lbSessionBatchSize;
    final private Duration lbSessionTimeout;
    final private Duration lbReadWait;
    final private Duration minHardCommitInterval;
    final private Duration metaHostTimeout;
    final private Duration dataHostTimeout;

    protected LbPassportConsumerSettings2Impl(String dynamicPropertyPrefix, int listenerMaxQueueSize, URI lbBaseUrl,
                                              String lbClientId, int lbSessionBatchSize, Duration lbSessionTimeout,
                                              Duration lbReadWait, Duration minHardCommitInterval, Duration metaHostTimeout,
                                              Duration dataHostTimeout) {
        super(dynamicPropertyPrefix);
        this.listenerMaxQueueSize = listenerMaxQueueSize;
        this.lbBaseUrl = lbBaseUrl;
        this.lbClientId = lbClientId;
        this.lbSessionBatchSize = lbSessionBatchSize;
        this.lbSessionTimeout = lbSessionTimeout;
        this.lbReadWait = lbReadWait;
        this.minHardCommitInterval = minHardCommitInterval;
        this.metaHostTimeout = metaHostTimeout;
        this.dataHostTimeout = dataHostTimeout;
    }

    protected LbPassportConsumerSettings2Impl(String dynamicPropertyPrefix, int listenerMaxQueueSize, URI lbBaseUrl,
                                              String lbClientId, int lbSessionBatchSize, Duration lbSessionTimeout,
                                              Duration lbReadWait, Duration minHardCommitInterval, Duration metaHostTimeout,
                                              Duration dataHostTimeout, LbTopicFilter lbTopicFilter) {
        super(dynamicPropertyPrefix, lbTopicFilter);
        this.listenerMaxQueueSize = listenerMaxQueueSize;
        this.lbBaseUrl = lbBaseUrl;
        this.lbClientId = lbClientId;
        this.lbSessionBatchSize = lbSessionBatchSize;
        this.lbSessionTimeout = lbSessionTimeout;
        this.lbReadWait = lbReadWait;
        this.minHardCommitInterval = minHardCommitInterval;
        this.metaHostTimeout = metaHostTimeout;
        this.dataHostTimeout = dataHostTimeout;
    }

    @Override
    protected int getListenerMaxQueueSize() {
        return listenerMaxQueueSize;
    }

    @Override
    protected URI getLbBaseUrl() {
        return lbBaseUrl;
    }

    @Override
    protected String getLbClientId() {
        return lbClientId;
    }

    @Override
    protected int getLbSessionBatchSize() {
        return lbSessionBatchSize;
    }

    @Override
    protected Duration getLbSessionTimeout() {
        return lbSessionTimeout;
    }

    @Override
    protected Duration getLbReadWait() {
        return lbReadWait;
    }

    @Override
    protected Duration getMinHardCommitInterval() {
        return minHardCommitInterval;
    }

    @Override
    protected Duration getMetaHostTimeout() {
        return metaHostTimeout;
    }

    @Override
    protected Duration getDataHostTimeout() {
        return dataHostTimeout;
    }
}
