package ru.yandex.chemodan.app.telemost.tasks;

import lombok.AllArgsConstructor;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.app.telemost.services.StreamService;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

@AllArgsConstructor
public class CheckStreamsLiveWorker extends DelayingWorkerServiceBeanSupport {
    private static final Logger logger = LoggerFactory.getLogger(CheckStreamsLiveWorker.class);

    private final StreamService streamService;

    @Override
    @Value("${check-streams-live.worker-delay}")
    public void setDelay(Duration delay) {
        super.setDelay(delay);
    }

    @Override
    protected void execute() {
        logger.info("Start check streams live.");
        streamService.checkStreamsLive();
        logger.info("Finish check streams live.");
    }

}
