package ru.yandex.chemodan.app.telemost.ugcLive;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.ugcLive.model.LineInfo;
import ru.yandex.chemodan.app.telemost.ugcLive.model.StreamAction;
import ru.yandex.chemodan.app.telemost.ugcLive.model.StreamSchedule;
import ru.yandex.chemodan.app.telemost.ugcLive.model.StreamState;

public interface UgcLiveClient {

    long createLine(String name);

    LineInfo getLineInfo(long lineId);

    void deleteLine(long lineId);

    String createEpisode(long lineId, String title);

    Option<StreamState> getStreamState(String episodeSlug);

    void performStreamAction(String episodeSlug, StreamAction action);

    void deleteEpisode(String episodeSlug);

    StreamSchedule getSchedule();
}
