package ru.yandex.chemodan.app.telemost.ugcLive.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;

@Getter
public class LineInfo {

    private final String rtmpKey;
    private final Option<String> episodeSlug;
    private final Option<StreamState> streamState;

    @JsonCreator
    public LineInfo(
            @JsonProperty(value = "rtmp_key", required = true) String rtmpKey,
            @JsonProperty("slug") Option<String> episodeSlug,
            @JsonProperty("stream_state") Option<StreamState> streamState
    ) {
        this.rtmpKey = rtmpKey;
        this.episodeSlug = episodeSlug;
        this.streamState = streamState;
    }
}
