package ru.yandex.chemodan.app.telemost.ugcLive.model;

import lombok.AllArgsConstructor;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

@AllArgsConstructor
public enum StreamAction implements StringEnum {
    PUBLISH("publish", StreamState.ONAIR),
    CANCEL("cancel", StreamState.CANCELLED),
    STOP("stop", StreamState.FINISHED),
    ;

    public static final StringEnumResolver<StreamAction> R = StringEnumResolver.r(StreamAction.class);

    private final String value;
    private final StreamState resultState;

    @Override
    public String value() {
        return value;
    }

    public StreamState getResultState() {
        return resultState;
    }
}
