package ru.yandex.chemodan.app.telemost.ugcLive.model;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

public enum StreamState implements StringEnum {
    OFFLINE("offline", StreamAction.CANCEL),
    CANCELLED("cancelled"),
    PREPARING("preparing", StreamAction.CANCEL),
    READY("ready", StreamAction.PUBLISH, StreamAction.CANCEL),
    ONAIR("onair", StreamAction.STOP),
    FINISHING("finishing"),
    FINISHED("finished"),
    ;

    public static final StringEnumResolver<StreamState> R = StringEnumResolver.r(StreamState.class);

    private final String value;
    private final ListF<StreamAction> actions;

    StreamState(String value, StreamAction... applicableActions) {
        this.value = value;
        this.actions = Cf.x(applicableActions);
    }

    @Override
    public String value() {
        return value;
    }

    public ListF<StreamAction> getApplicableActions() {
        return actions;
    }
}
