package ru.yandex.chemodan.app.telemost.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.result.error.AnyExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class LoggingAnyExceptionHandler extends AnyExceptionHandler {

    private static final Logger errorLogger = LoggerFactory.getLogger("error");

    @Override
    public Option<?> handleException(WebRequest request, ActionInvocationContext context, ExceptionResolver resolver,
                                     Exception exception)
    {
        errorLogger.error("http request unhandled: ", exception);
        return super.handleException(request, context, resolver, exception);
    }
}
