package ru.yandex.chemodan.app.telemost.web.v1.actions;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.services.ConferenceService;
import ru.yandex.chemodan.app.telemost.services.UserService;
import ru.yandex.chemodan.app.telemost.services.model.ConferenceUriData;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;
import ru.yandex.chemodan.app.telemost.web.v1.model.AuthorizationData;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;

@ActionContainer
public class AuthorizationActions {

    private final ConferenceService conferenceService;
    private final UserService userService;

    public AuthorizationActions(ConferenceService conferenceService, UserService userService)
    {
        this.conferenceService = conferenceService;
        this.userService = userService;
    }

    private void addUserIfNotExists(Option<PassportOrYaTeamUid> uid) {
        uid.ifPresent(userService::addUserIfNotExists);
    }

    @Path(value = "/v1/yandex-team/conferences/{uri:.*}/authorized-uri", methods = HttpMethod.POST)
    public AuthorizationData authorizeYaTeamConference(@RequestParam("uid") Option<PassportOrYaTeamUid> uid,
                                                       @PathParam("uri") String uri)
    {
        addUserIfNotExists(uid);

        ConferenceUriData conferenceUriData = conferenceService.getYaTeamConferenceUriId(uri);
        return new AuthorizationData(
                conferenceService.getYaTeamAuthorizationConferenceUri(uid, conferenceUriData)
        );
    }
}
