package ru.yandex.chemodan.app.telemost.web.v1.actions;

import ru.yandex.chemodan.app.telemost.exceptions.ConferenceNotFoundTelemostException;
import ru.yandex.chemodan.app.telemost.services.ConferenceService;
import ru.yandex.chemodan.app.telemost.services.RoomService;
import ru.yandex.chemodan.app.telemost.services.model.Conference;
import ru.yandex.chemodan.app.telemost.web.v1.model.AddParticipantData;
import ru.yandex.chemodan.app.telemost.web.v1.model.RemoveParticipantData;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@ActionContainer
public class JicofoActions {

    private final ConferenceService conferenceService;

    private final RoomService roomService;

    public JicofoActions(ConferenceService conferenceService, RoomService roomService) {
        this.conferenceService = conferenceService;
        this.roomService = roomService;
    }

    @Path(value = "/v1/jicofo/rooms/{room_id}/participants/{peer_id}", methods = {HttpMethod.PUT})
    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    public AddParticipantData addPeerToRoom(@PathParam("room_id") String roomId, @PathParam("peer_id") String peerId) {
        Conference conference = conferenceService.findConferenceUnsafe(roomId)
                .getOrThrow(ConferenceNotFoundTelemostException::new);
        roomService.addPeerToConference(conference, peerId);
        return new AddParticipantData();
    }

    @Path(value = "/v1/jicofo/rooms/{room_id}/participants/{peer_id}", methods = {HttpMethod.DELETE})
    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    public RemoveParticipantData removePeerFromRoom(@PathParam("room_id") String roomId,
            @PathParam("peer_id") String peerId)
    {
        Conference conference = conferenceService.findConferenceUnsafe(roomId)
                .getOrThrow(ConferenceNotFoundTelemostException::new);
        roomService.removePeerFromConference(conference, peerId);
        return new RemoveParticipantData();
    }
}
