package ru.yandex.chemodan.app.telemost.web.v1.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.telemost.services.model.Conference;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@NoArgsConstructor
@AllArgsConstructor
@Getter
public class ConferenceData extends DefaultObject implements JacksonPojo {

    @JsonProperty("uri")
    private String uri;

    @JsonProperty("conf_id")
    private String conferenceId;

    @JsonProperty("conf_pwd")
    private String conferencePassword;

    @JsonProperty("limit_type")
    private String limitType;

    @JsonProperty("client_configuration")
    private MapF<String, Object> clientConfiguration;

    public ConferenceData(Conference conference, MapF<String, Object> clientConfiguration) {
        this(conference.getUri(), conference.getConferenceId(), conference.getConferencePassword(),
                conference.getLimitType().name(),
                clientConfiguration);
    }
}
