package ru.yandex.chemodan.app.telemost.web.v2.actions;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.telemost.appmessages.AppMessageProcessor;
import ru.yandex.chemodan.app.telemost.appmessages.TransportMessage;
import ru.yandex.chemodan.app.telemost.web.v2.model.AppMessagePayload;
import ru.yandex.chemodan.app.telemost.web.v2.model.AppMessageRequest;
import ru.yandex.chemodan.app.telemost.web.v2.model.AppMessageResponse;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.BoundByJackson;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@ActionContainer
@AllArgsConstructor
public class AppMessageActionsV2 {

    private final AppMessageProcessor appMessageProcessor;

    @Path(value = "/v2/app_messages/handle_app_message", methods = {HttpMethod.POST})
    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    public AppMessageResponse handleAppMessage(@BoundByJackson AppMessageRequest request)
    {
        TransportMessage transportMessage = appMessageProcessor.processMessage(
                request.getRoomId(), request.getPeerId(),
                new TransportMessage(request.getPayload().getType(), request.getPayload().getPayload()));
        return new AppMessageResponse(new AppMessagePayload(transportMessage.getType(), transportMessage.getPayload()));
    }
}
