package ru.yandex.chemodan.app.telemost.web.v2.actions;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.telemost.repository.dao.UserDao;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@ActionContainer
@AllArgsConstructor
public class BillingActionsV2 {
    private UserDao userDao;

    @Path(value = "/v2/billing/broadcast/enable", methods = {HttpMethod.PUT})
    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    public void enableBroadcastFeature(@RequestParam("uid") String uid) {
        userDao.upsert(PassportOrYaTeamUid.parseUid(uid), true);
    }

    @Path(value = "/v2/billing/broadcast/disable", methods = {HttpMethod.PUT})
    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    public void disableBroadcastFeature(@RequestParam("uid") String uid) {
        userDao.upsert(PassportOrYaTeamUid.parseUid(uid), false);
    }
}
