package ru.yandex.chemodan.app.telemost.web.v2.actions;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.telemost.exceptions.ConferenceNotFoundTelemostException;
import ru.yandex.chemodan.app.telemost.repository.dao.ConferenceUserDao;
import ru.yandex.chemodan.app.telemost.repository.model.ApiVersion;
import ru.yandex.chemodan.app.telemost.repository.model.ConferenceUserDto;
import ru.yandex.chemodan.app.telemost.repository.model.UserRole;
import ru.yandex.chemodan.app.telemost.services.ConferenceParticipantsService;
import ru.yandex.chemodan.app.telemost.services.ConferenceService;
import ru.yandex.chemodan.app.telemost.services.model.Conference;
import ru.yandex.chemodan.app.telemost.services.model.ConferenceParticipant;
import ru.yandex.chemodan.app.telemost.web.v2.model.ConferenceParticipantData;
import ru.yandex.chemodan.app.telemost.web.v2.model.PeerData;
import ru.yandex.chemodan.web.EmptyPojo;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.BoundByJackson;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@ActionContainer
@AllArgsConstructor
public class JicofoActionsV2 {

    private final ConferenceService conferenceService;
    private final ConferenceParticipantsService conferenceParticipantsService;
    private final ConferenceUserDao conferenceUserDao;

    @Path(methods = HttpMethod.PUT, value = "/v2/jicofo/conferences/{confId:.*}/peers/{peerId:.*}")
    @WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
    public EmptyPojo savePeer(@PathParam("confId") String conferenceId,
                              @PathParam("peerId") String peerId,
                              @BoundByJackson PeerData peer)
    {
        Conference conference = conferenceService.findOrCreateConferenceUnsafe(conferenceId);
        conferenceParticipantsService
                .mergeByPeerId(peerId, conference, Option.of(peer.getDisplayName()), Option.empty(), ApiVersion.V1);

        return EmptyPojo.INSTANCE;
    }

    @Path(methods = HttpMethod.GET, value = "/v2/jicofo/conferences/{confId:.*}/peers/{peerId:.*}")
    @WithMasterSlavePolicy(MasterSlavePolicy.R_SYNC_SM)
    public ConferenceParticipantData getPeer(@PathParam("confId") String conferenceId,
                                             @PathParam("peerId") String peerId)
    {
        Conference conference = conferenceService.findConferenceUnsafe(conferenceId)
                .getOrThrow(ConferenceNotFoundTelemostException::new);
        ConferenceParticipant participant = conferenceParticipantsService.findConferenceParticipant(conference, peerId);
        UserRole role = participant.getUid()
                .map(uid -> conferenceUserDao.findByConferenceAndUid(conference.getDbId(), uid))
                .flatMapO(Function.identityF())
                .map(ConferenceUserDto::getRole)
                .orElse(UserRole.MEMBER);
        return new ConferenceParticipantData(participant, role);
    }
}
