package ru.yandex.chemodan.app.telemost.web.v2.actions;

import lombok.AllArgsConstructor;

import ru.yandex.chemodan.app.telemost.services.ConferencePeerService;
import ru.yandex.chemodan.app.telemost.services.ConferenceService;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;
import ru.yandex.chemodan.app.telemost.services.model.User;
import ru.yandex.chemodan.app.telemost.web.v2.model.UserData;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

@ActionContainer
@AllArgsConstructor
public class UsersActionsV2 {
    private final ConferencePeerService conferencePeerService;
    private final ConferenceService conferenceService;

    @Path(value = "/v2/users/{uid}", methods = {HttpMethod.GET})
    @WithMasterSlavePolicy(MasterSlavePolicy.R_SYNC_SM)
    public UserData getUser(@PathParam("uid") PassportOrYaTeamUid uid)
    {
        User user = conferencePeerService.findUser(uid);

        return new UserData(user,
                conferenceService.isBroadcastAllowed(user.isStaff()),
                conferenceService.isBroadcastFeatureEnabled(uid));
    }
}
