package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.services.model.Broadcast;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class BroadcastData extends DefaultObject implements JacksonPojo {
    @JsonProperty("broadcast_uri")
    private final String broadcastUri;

    @JsonProperty("broadcast_chat_path")
    private Option<String> broadcastChatPath;

    public BroadcastData(Broadcast broadcast) {
        this.broadcastUri = broadcast.getUri();
        this.broadcastChatPath = broadcast.getChatPath();
    }
}
