package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class BroadcastInitData extends DefaultObject implements JacksonPojo {

    @JsonProperty("caption")
    private final Option<String> caption;

    @JsonProperty("description")
    private final Option<String> description;

    public BroadcastInitData() {
        this.caption = Option.empty();
        this.description = Option.empty();
    }

}
