package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.BroadcastDto;
import ru.yandex.chemodan.app.telemost.repository.model.StreamDto;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class BroadcastStateData extends DefaultObject implements JacksonPojo {
    @JsonProperty("broadcast_uri")
    private final String broadcastUri;

    @JsonProperty("broadcast_chat_path")
    private Option<String> broadcastChatPath;

    @JsonProperty("created_by")
    private String createdBy;

    @JsonProperty("status")
    private BroadcastStatus status;

    @JsonProperty("started_by")
    private final Option<String> streamStartedBy;

    @JsonProperty("started_at")
    private final Option<Long> streamStartedAt;

    @JsonProperty("translator_peer_id")
    private final Option<String> translatorPeerId;

    @JsonProperty("stream_uri")
    private final Option<String> streamUri;

    public BroadcastStateData(BroadcastDto broadcast, Option<StreamDto> stream) {
        this.broadcastUri = broadcast.getBroadcastUri();
        this.broadcastChatPath = broadcast.getBroadcastChatPath();
        this.createdBy = broadcast.getCreatedBy();
        this.status = broadcast.getStatus();
        this.streamStartedBy = stream.flatMapO(StreamDto::getOwnerUid);
        this.streamStartedAt = stream.flatMapO(x -> x.getStartedAt().map(t -> t.getMillis() / 1000));
        this.translatorPeerId = stream.flatMapO(StreamDto::getTranslatorPeerId);
        this.streamUri = stream.map(StreamDto::getStreamUri);
    }
}
