package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;

import ru.yandex.chemodan.app.telemost.chat.model.ChatHistory;
import ru.yandex.chemodan.app.telemost.chat.model.ChatHistoryItem;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.time.MoscowTime;

@AllArgsConstructor
@Getter
public class ChatHistoryData extends DefaultObject implements JacksonPojo {

    @JsonProperty("timestamp_from")
    private final Long timestampFrom;

    @JsonProperty("timestamp_to")
    private final Long timestampTo;

    @JsonProperty("history")
    private final String history;

    public ChatHistoryData(ChatHistory chatHistory) {
        this.timestampFrom = chatHistory.getTimestampFrom();
        this.timestampTo = chatHistory.getTimestampTo();

        StringBuilder sb = new StringBuilder();
        for (ChatHistoryItem item : chatHistory.getItems()) {
            if (item.getMessage().isEmpty()) {
                continue;
            }
            String a = (new Instant(item.getTimestamp())).toString(
                    DateTimeFormat.forPattern("dd.MM HH:mm").withZone(MoscowTime.TZ));
            sb.append(item.getDisplayName()).append(
                    " [" + a + "]").append(":\n").append(item.getMessage()).append("\n\n");
        }
        this.history = sb.toString();
    }

    public ChatHistoryData() {
        this.timestampFrom = 0L;
        this.timestampTo = 0L;
        this.history = "";
    }
}
