package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.telemost.services.model.Conference;
import ru.yandex.chemodan.app.telemost.services.model.RoomConnectionInfo;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@NoArgsConstructor
@AllArgsConstructor
@Getter
public class ConferenceConnectionData extends DefaultObject implements JacksonPojo {
    @JsonUnwrapped
    private ConferenceData conferenceData;

    @JsonProperty("ws_uri")
    private String websocketUri;

    @JsonProperty("peer_id")
    private String userId;

    @JsonProperty("media_session_id")
    private String mediaSessionId;

    @JsonProperty("peer_token")
    private String peerToken;

    @JsonProperty("client_configuration")
    private MapF<String, Object> clientConfiguration;

    @JsonProperty("conference_state")
    private ConferenceStateData conferenceState;

    public ConferenceConnectionData(Conference conference, RoomConnectionInfo room,
            MapF<String, Object> clientConfiguration)
    {
        this.conferenceData = new ConferenceData(conference);
        this.websocketUri = room.getWebsocketUri();
        this.userId = room.getUserId();
        this.mediaSessionId = room.getMediaSessionId();
        this.peerToken = room.getPeerToken();
        this.clientConfiguration = clientConfiguration;
        this.conferenceState = new ConferenceStateData(conference.getConferenceState());
    }
}
