package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.chemodan.app.telemost.services.model.Conference;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@NoArgsConstructor
@AllArgsConstructor
@Getter
public class ConferenceData extends DefaultObject implements JacksonPojo {
    @JsonProperty("uri")
    private String uri;

    @JsonProperty("room_id")
    private String roomId;

    @JsonProperty("safe_room_id")
    private String safeRoomId;

    @JsonProperty("is_yandex_team")
    private boolean isYaTeam;

    @JsonProperty("conference_state")
    private ConferenceStateData conferenceState;

    public ConferenceData(Conference conference) {
        this.uri = conference.getUri();
        this.roomId = conference.getRoomId();
        this.safeRoomId = conference.getSafeRoomId();
        this.isYaTeam = conference.isYaTeam();
        this.conferenceState = new ConferenceStateData(conference.getConferenceState());
    }
}
