package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.repository.model.UserRole;
import ru.yandex.chemodan.app.telemost.services.model.ConferenceParticipant;
import ru.yandex.chemodan.app.telemost.services.model.PassportOrYaTeamUid;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@NoArgsConstructor
public class ConferenceParticipantData extends DefaultObject implements JacksonPojo {
    @JsonProperty("uid")
    private Option<String> uid;
    @JsonProperty("peer_id")
    private String peerId;
    @JsonProperty("avatar_url")
    private Option<String> avatarUrl;
    @JsonProperty("is_default_avatar")
    private Option<Boolean> isDefaultAvatar;
    @JsonProperty("display_name")
    private String displayName;
    @JsonProperty("role")
    private UserRole role;

    public ConferenceParticipantData(ConferenceParticipant participant, UserRole role) {
        this.uid = participant.getUid().map(PassportOrYaTeamUid::asString);
        this.peerId = participant.getPeerId();
        this.avatarUrl = participant.getAvatarUrl();
        this.isDefaultAvatar = participant.getIsDefaultAvatar();
        this.displayName = participant.getDisplayName();
        this.role = role;
    }
}
