package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.services.model.ConferenceState;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class ConferenceStateData extends DefaultObject implements JacksonPojo {
    @JsonProperty("local_recording_allowed")
    private final boolean localRecordingAllowed;

    @JsonProperty("cloud_recording_allowed")
    private final boolean cloudRecordingAllowed;

    @JsonProperty("chat_allowed")
    private final boolean chatAllowed;

    @JsonProperty("control_allowed")
    private final boolean controlAllowed;

    @JsonProperty("broadcast_allowed")
    private final boolean broadcastAllowed;

    @JsonProperty("broadcast_feature_enabled")
    private final boolean broadcastFeatureEnabled;

    @JsonProperty("chat_path")
    private Option<String> chatPath;

    @JsonProperty("broadcast_data")
    private Option<BroadcastStateData> broadcastData;

    public ConferenceStateData(ConferenceState conferenceState) {
        this.localRecordingAllowed = conferenceState.isLocalRecordingAllowed();
        this.cloudRecordingAllowed = conferenceState.isCloudRecordingAllowed();
        this.chatAllowed = conferenceState.isChatAllowed();
        this.controlAllowed = conferenceState.isControlAllowed();
        this.broadcastAllowed = conferenceState.isBroadcastAllowed();
        this.broadcastFeatureEnabled = conferenceState.isBroadcastFeatureEnabled();
        this.chatPath = conferenceState.getChatPath();
        this.broadcastData = conferenceState.getBroadcast();
    }

    public void setChatPath(String chatPath) {
        this.chatPath = Option.of(chatPath);
    }
}
