package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.services.model.StreamConnection;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class StreamConnectionData extends DefaultObject implements JacksonPojo {
    @JsonProperty("stream_uri")
    private final Option<String> streamUri;

    @JsonProperty("start_event_time")
    private final Option<Long> startEventTime;

    @JsonProperty("caption")
    private final Option<String> caption;

    @JsonProperty("description")
    private final Option<String> description;

    @JsonProperty("broadcast_chat_path")
    private final Option<String> broadcastChatPath;

    @JsonProperty("status")
    private final BroadcastStatus status;

    @JsonProperty("display_name")
    private final Option<String> displayName;

    @JsonProperty("started_at")
    private final Option<Long> streamStartedAt;

    public StreamConnectionData(StreamConnection streamConnection) {
        this.streamUri = streamConnection.getStreamUri();
        this.startEventTime = streamConnection.getStartEventTime();
        this.caption = streamConnection.getCaption();
        this.description = streamConnection.getDescription();
        this.broadcastChatPath = streamConnection.getBroadcastChatPath();
        this.status = streamConnection.getStatus();
        this.displayName = streamConnection.getDisplayName();
        this.streamStartedAt = streamConnection.getStreamStartedAt();
    }
}
