package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
@JsonIgnoreProperties(ignoreUnknown = true)
public class StreamData extends DefaultObject implements JacksonPojo {
    @JsonProperty("owner_uid")
    private final String ownerUid;

    @JsonProperty("started_at")
    private final Long startedAt;

    @JsonProperty("stopped_at")
    private final Option<Long> stoppedAt;

    @JsonProperty("stream_uri")
    private final Option<String> streamUri;

}
