package ru.yandex.chemodan.app.telemost.web.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.telemost.services.model.User;
import ru.yandex.chemodan.web.JacksonPojo;
import ru.yandex.misc.lang.DefaultObject;

@AllArgsConstructor
@Getter
public class UserData extends DefaultObject implements JacksonPojo {
    @JsonProperty("uid")
    private String uid;

    @JsonProperty("display_name")
    private Option<String> displayName;

    @JsonProperty("avatar_url")
    private Option<String> avatarUrl;

    @JsonProperty("is_default_avatar")
    private Option<Boolean> isDefaultAvatar;

    @JsonProperty("is_yandex_staff")
    private boolean yandexStaff;

    @JsonProperty("broadcast_allowed")
    private final boolean broadcastAllowed;

    @JsonProperty("broadcast_feature_enabled")
    private final boolean broadcastFeatureEnabled;

    public UserData(User user, boolean broadcastAllowed, boolean broadcastFeatureEnabled) {
        this(user.getUid().asString(), user.getDisplayName(), user.getAvatarUrl(),
                user.getIsDefaultAvatar(), user.isStaff(),
                broadcastAllowed, broadcastFeatureEnabled);
    }
}
