package ru.yandex.chemodan.app.uaas.actions;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.chemodan.app.uaas.parser.UserAgentObject;
import ru.yandex.chemodan.app.uaas.parser.UserAgentParser;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestHeader;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;

/**
 * @author tolmalev
 */
@Action
@Path(value = "/experiments", methods = HttpMethod.GET)
public class GetExperimentsAction extends PublicCloneableActionSupport {
    private final UserAgentParser userAgentParser;
    private final ExperimentsManager experimentsManager;

    @RequestHeader("User-Agent")
    private Option<String> userAgent;

    @RequestParam
    private Option<Long> uid;

    @RequestParam
    private Option<Long> uuid;

    public GetExperimentsAction(UserAgentParser userAgentParser, ExperimentsManager experimentsManager) {
        this.userAgentParser = userAgentParser;
        this.experimentsManager = experimentsManager;
    }

    @Override
    public Object execute() throws Exception {
        final Option<UserAgentObject> userAgentObject = userAgentParser.parse(userAgent);
        final JsonNode result = experimentsManager.getJson(uid.orElse(uuid), userAgentObject);
        return new JsonNodeSerializer(result);
    }
}
