package ru.yandex.chemodan.app.uaas.actions;

import java.io.OutputStream;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.result.SelfSerializer;
import ru.yandex.commune.a3.action.result.Variant;
import ru.yandex.commune.a3.action.result.Variants;
import ru.yandex.commune.a3.action.result.type.MediaType;

public class JsonNodeSerializer extends SelfSerializer {

    private final JsonNode result;

    public JsonNodeSerializer(JsonNode result) {
        this.result = result;
    }

    @Override
    protected void serialize(Variant variant, ActionInvocationContext context, OutputStream stream) throws Exception {
        stream.write(result.toString().getBytes());
        stream.flush();
    }

    @Override
    protected Variants getVariants() {
        return Variants.cons(MediaType.APPLICATION_JSON);
    }
}
