package ru.yandex.chemodan.app.uaas.actions;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.chemodan.app.uaas.parser.UserAgentParser;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        A3JettyContextConfiguration.class,
})
public class UaasActionsContextConfiguration {
    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/api/*", ""
        ));
    }

    @Bean
    public GetExperimentsAction getExperimentsAction(UserAgentParser userAgentParser, ExperimentsManager experimentsManager) {
        return new GetExperimentsAction(userAgentParser, experimentsManager);
    }

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo) {
        BenderMapper mapper = new BenderMapper();

        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator
                .addJsonBendingWithoutInvocationInfo(mapper).getBuilder()

                .addInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo),
                        new ThreadLocalCacheInterceptor()))
        ;

        return configurator.configure();
    }
}
