package ru.yandex.chemodan.app.uaas.admin;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.uaas.zk.UaasOverrideController;
import ru.yandex.chemodan.app.uaas.zk.UaasOverrideZkRegistry;
import ru.yandex.chemodan.app.uaas.zk.UserGroupsZkRegistry;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.admin.web.AdminApp;

/**
 * @author tolmalev
 */
@ActionContainer
public class UaasAdminContextConfiguration {
    @Autowired
    private AdminApp adminApp;

    @Bean
    public UaasOverridesAdminPage uaasOverridesAdminPage(UaasOverrideZkRegistry uaasOverrideZkRegistry, UaasOverrideController overrideController) {
        UaasOverridesAdminPage page = new UaasOverridesAdminPage(uaasOverrideZkRegistry, overrideController);

        adminApp.registerAdminPage("Overrides", Option.of("UAAS"), page);

        return page;
    }

    @Bean
    public UaasUserGroupsAdminPage uaasUserGroupsAdminPage(UserGroupsZkRegistry userGroupsZkRegistry) {
        UaasUserGroupsAdminPage page = new UaasUserGroupsAdminPage(userGroupsZkRegistry);

        adminApp.registerAdminPage("Groups", Option.of("UAAS"), page);

        return page;
    }
}
