<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <xsl:apply-templates select="override"/>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="override">
        <h1>Редактирвание оверрайда <xsl:value-of select="id"/></h1>
        <br/>
        <form action="/z/uaas/overrides/{id}" method="POST">
            <div class="form-group row">
                <label for="overrideId" class="col-sm-2 col-form-label">Уникальный id</label>
                <div class="col-sm-5">
                     <input class="form-control" name="overrideId" type="text" value="{id}"/>
                </div>
            </div>
            <div class="form-group row">
                <label for="description" class="col-sm-2 col-form-label">Описание</label>
                <div class="col-sm-5">
                    <input class="form-control" name="description" type="text" value="{description}"/>
                </div>
            </div>
            <div class="form-group row">
                <label for="experimentIds" class="col-sm-2 col-form-label">testIds выборок</label>
                <div class="col-sm-5">
                    <input class="form-control" name="experimentIds" type="text" value="{string-join(test-ids, ', ')}"/>
                </div>
            </div>
            <div class="form-group row">
                <label for="uids" class="col-sm-2 col-form-label">Выборка людей</label>
                <div class="col-sm-5">
                    <input class="form-control" name="uids" type="text" value="{string-join(uids, ', ')}"/>
                </div>
            </div>
            <div class="form-group row">
                <label for="overrideJson" class="col-sm-2 col-form-label">JSON</label>
                <div class="col-sm-5">
                    <textarea class="form-control" name="overrideJson" type="text" rows="20">
                        <xsl:value-of select="override-json"/>
                    </textarea>
                </div>
            </div>
            <button class="btn btn-primary">Сохранить</button>
        </form>
        <hr/>
        <a href="/z/uaas/overrides/delete/{id}" class="btn btn-danger" onclick="return confirm('Are you sure?')">Удалить</a>
    </xsl:template>
</xsl:stylesheet>
