<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <h1>Список оверрайдов экспериментов</h1>
                <br/>
                <table class="table table-striped table-condensed table-bordered">
                    <tr>
                        <th>id</th>
                        <th>description</th>
                        <th>links</th>
                    </tr>
                    <xsl:for-each select="overrides">
                        <tr>
                            <td>
                                <xsl:value-of select="id"/>
                            </td>
                            <td>
                                <xsl:value-of select="description"/>
                            </td>
                            <td>
                                <a href="/z/uaas/overrides/{id}">Edit</a>
                            </td>
                        </tr>
                    </xsl:for-each>
                </table>

                <hr/>
                <h3>Создать новый оверрайд</h3>
                <br/>
                <form action="/z/uaas/overrides" method="POST">
                    <div class="form-group row">
                        <label for="overrideId" class="col-sm-2 col-form-label">Уникальный id</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="overrideId" type="text"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="description" class="col-sm-2 col-form-label">Описание</label>
                        <div class="col-sm-5">
                            <input class="form-control" name="description" type="text"/>
                        </div>
                    </div>
                    <button class="btn btn-primary">Создать оверрайд</button>
                </form>
            </div>
        </div>
    </xsl:template>

</xsl:stylesheet>
