package ru.yandex.chemodan.app.uaas.admin;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.uaas.zk.ExperimentOverride;
import ru.yandex.chemodan.app.uaas.zk.UaasOverrideController;
import ru.yandex.chemodan.app.uaas.zk.UaasOverrideZkRegistry;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@ActionContainer
public class UaasOverridesAdminPage {
    private final UaasOverrideZkRegistry uaasOverrideZkRegistry;
    private final UaasOverrideController overrideController;

    public UaasOverridesAdminPage(UaasOverrideZkRegistry uaasOverrideZkRegistry, UaasOverrideController overrideController) {
        this.uaasOverrideZkRegistry = uaasOverrideZkRegistry;
        this.overrideController = overrideController;
    }

    @ZAction(defaultAction = true, file = "list_overrides.xsl")
    @Path("/uaas/overrides")
    public ListOverridesPojo listOverrides() {
        return new ListOverridesPojo(uaasOverrideZkRegistry.getAll().toList());
    }

    @ZAction(file = "edit_override.xsl")
    @Path(methods = HttpMethod.GET, value = "/uaas/overrides/{overrideId}")
    public OneOverridePojo getOverride(@PathParam("overrideId") String id) {
        return new OneOverridePojo(uaasOverrideZkRegistry.get(id));
    }

    @Path(methods = HttpMethod.POST, value = "/uaas/overrides")
    public void createNewOverride(
            @RequestParam("overrideId") String id,
            @RequestParam("description") String description)
    {
        if (uaasOverrideZkRegistry.getO(id).isPresent()) {
            throw new ZRedirectException("/uaas/overrides/" + id);
        }

        overrideController.put(
                id,
                Cf.list(),
                Cf.list(),
                Option.ofNullable(StringUtils.trimToNull(description)).orElse(Option.of("Обязательно заполните описание")),
                        "{\n" +
                        "  \"HANDLER\": \"DISK\", \n" +
                        "  \"CONTEXT\": {\n" +
                        "     \"DISK\": {\n" +
                        "      \"flags\": [\n" +
                        "      ], \n" +
                        "      \"testid\": [\n" +
                        "      ]\n" +
                        "    }\n" +
                        "  }\n" +
                        "}\n"
        );

        throw new ZRedirectException("/uaas/overrides/" + id);
    }

    @Path(methods = HttpMethod.POST, value = "/uaas/overrides/{override_id}")
    public void saveOverride(
            @PathParam("override_id") String id,
            @RequestParam("uids") String uidsStr,
            @RequestParam("experimentIds") String experimentIdsStr,
            @RequestParam("overrideJson") String overrideJson,
            @RequestParam("description") String description)
    {
        ListF<String> uids = Cf.x(uidsStr.split("[, ]")).map(StringUtils::trim).filter(StringUtils::isNotBlank);
        ListF<Integer> experimentIds =
                Cf.x(experimentIdsStr.split("[, ]")).map(StringUtils::trim).filter(StringUtils::isNotBlank).map(Integer::parseInt);

        overrideController.put(
                id,
                uids,
                experimentIds,
                Option.of(description),
                overrideJson
        );
        throw new ZRedirectException("/uaas/overrides/" + id);
    }

    @Path(methods = HttpMethod.GET, value = "/uaas/overrides/delete/{override_id}")
    public void deleteOverride(@PathParam("override_id") String id) {
        uaasOverrideZkRegistry.remove(id);
        throw new ZRedirectException("/uaas/overrides/");
    }

    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class ListOverridesPojo {
        public final ListF<ExperimentOverride> overrides;
    }

    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class OneOverridePojo {
        public final ExperimentOverride override;
    }
}
