<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:z="urn:zscript-functions">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
    </xsl:template>

    <xsl:template match="page" mode="head-extra">
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <xsl:apply-templates select="group"/>
            </div>
        </div>
    </xsl:template>

    <xsl:template match="group">
        <h1>Редактирвание группы <xsl:value-of select="id"/></h1>
        <br/>
        <form action="/z/uaas/groups/{id}" method="POST">
            <div class="form-group row">
                <label for="groupId" class="col-sm-2 col-form-label">Уникальный id</label>
                <div class="col-sm-5">
                     <input class="form-control" name="groupId" type="text" value="{id}"/>
                </div>
            </div>
            <div class="form-group row">
                <label for="description" class="col-sm-2 col-form-label">Описание</label>
                <div class="col-sm-5">
                    <input class="form-control" name="description" type="text" value="{description}"/>
                </div>
            </div>
            <div class="form-group row">
                <label for="uids" class="col-sm-2 col-form-label">uids</label>
                <div class="col-sm-5">
                    <input class="form-control" name="uids" type="text" value="{string-join(uids, ', ')}"/>
                </div>
            </div>
            <button class="btn btn-primary">Сохранить</button>
        </form>
        <hr/>
        <a href="/z/uaas/groups/delete/{id}" class="btn btn-danger" onclick="return confirm('Are you sure?')">Удалить</a>
    </xsl:template>
</xsl:stylesheet>
