package ru.yandex.chemodan.app.uaas.admin;

import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.uaas.zk.UserGroupsZkRegistry;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@ActionContainer
public class UaasUserGroupsAdminPage {
    private final UserGroupsZkRegistry userGroupsZkRegistry;

    public UaasUserGroupsAdminPage(UserGroupsZkRegistry userGroupsZkRegistry) {
        this.userGroupsZkRegistry = userGroupsZkRegistry;
    }

    @ZAction(defaultAction = true, file = "list_groups.xsl")
    @Path("/uaas/groups")
    public ListGroupsPojo listGroups() {
        return new ListGroupsPojo(userGroupsZkRegistry.getAll().toList());
    }

    @ZAction(file = "edit_group.xsl")
    @Path(methods = HttpMethod.GET, value = "/uaas/groups/{groupId}")
    public OneGroupPojo getGroup(@PathParam("groupId") String id) {
        return new OneGroupPojo(userGroupsZkRegistry.get(id));
    }

    @Path(methods = HttpMethod.POST, value = "/uaas/groups")
    public void createNewOverride(
            @RequestParam("groupId") String id,
            @RequestParam("description") String description)
    {
        if (userGroupsZkRegistry.getO(id).isPresent()) {
            throw new ZRedirectException("/uaas/groups/" + id);
        }

        userGroupsZkRegistry.put(new UserGroupsZkRegistry.UserGroup(
                id,
                Cf.set(),
                Option.ofNullable(StringUtils.trimToNull(description)).getOrElse("Обязательно заполните описание")
        ));

        throw new ZRedirectException("/uaas/groups/" + id);
    }

    @Path(methods = HttpMethod.POST, value = "/uaas/groups/{group_id}")
    public void saveGroup(
            @PathParam("group_id") String id,
            @RequestParam("uids") String uidsStr,
            @RequestParam("description") String description)
    {
        ListF<String> uids = Cf.x(uidsStr.split("[, ]")).map(StringUtils::trim).filter(StringUtils::isNotBlank);

        userGroupsZkRegistry.put(new UserGroupsZkRegistry.UserGroup(
                id,
                uids.unique(),
                description
        ));
        throw new ZRedirectException("/uaas/groups/" + id);
    }

    @Path(methods = HttpMethod.GET, value = "/uaas/groups/delete/{group_id}")
    public void deleteGroup(@PathParam("group_id") String id) {
        userGroupsZkRegistry.remove(id);
        throw new ZRedirectException("/uaas/groups/");
    }

    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class ListGroupsPojo {
        public final ListF<UserGroupsZkRegistry.UserGroup> groups;
    }

    @Data
    @BenderBindAllFields
    @XmlRootElement(name = "content")
    private static class OneGroupPojo {
        public final UserGroupsZkRegistry.UserGroup group;
    }
}
