package ru.yandex.chemodan.app.uaas.client;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

@Configuration
public class UaasClientContextConfiguration {

    @Bean
    public UaasClient uaasSearchClient(
            @Value("${uaas.host}") String host,
            @Value("${uaas.cache.ttl.minutes}") int cacheTtlMinutes,
            @Value("${uaas.long.cache.ttl.minutes}") int longCacheTtlMinutes)
    {
        HttpClient httpClient = uaasHttpClientConfigurator().configure();
        return new UaasClient(httpClient, host, cacheTtlMinutes, longCacheTtlMinutes);
    }

    @Bean
    @OverridableValuePrefix("uaas")
    public HttpClientConfigurator uaasHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }


}
