package ru.yandex.chemodan.app.uaas.experiments;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.uaas.client.UaasClient;
import ru.yandex.chemodan.app.uaas.client.UaasClientContextConfiguration;
import ru.yandex.chemodan.app.uaas.parser.UaasConditionParser;
import ru.yandex.chemodan.app.uaas.parser.UaasParserContextConfiguration;
import ru.yandex.chemodan.app.uaas.zk.UaasOverrideController;
import ru.yandex.chemodan.app.uaas.zk.UaasOverrideZkConfiguration;

@Configuration
@Import({
        UaasClientContextConfiguration.class,
        UaasParserContextConfiguration.class,
        UaasOverrideZkConfiguration.class,
})
public class ExperimentsContextConfigutation {

    @Bean
    public ExperimentsManager experimentsManager(UaasConditionParser uaasConditionParser, UaasOverrideController uaasOverrideController, UaasClient uaasClient) {
        return new ExperimentsManager(uaasConditionParser, uaasOverrideController, uaasClient);
    }
}
