package ru.yandex.chemodan.app.uaas.flags;

import java.io.IOException;
import java.util.Base64;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class ExperimentHeaderParser {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentHeaderParser.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static ListF<JsonNode> parseRawExpHeaderValuesToJson(String value) {
        return Cf.x(value.split(","))
                .map(Base64.getDecoder()::decode)
                .map(String::new)
                .flatMap(str -> {
                    try {
                        return Option.of(objectMapper.readTree(str));
                    } catch (IOException e) {
                        logger.error("failed to parse json from uaas: {}", e);
                        return Option.empty();
                    }
                });
    }
}
