package ru.yandex.chemodan.app.uaas.parser;

import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.ExpressionParser;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class UaasConditionParser {

    private static final Logger logger = LoggerFactory.getLogger(UaasConditionParser.class);

    private ExpressionParser parser;

    public UaasConditionParser(ExpressionParser parser) {
        this.parser = parser;
    }

    public Boolean validate(Option<String> condition, Option<UserAgentObject> userAgentObject) {
        if (condition.isPresent() && userAgentObject.isPresent()) {
            try {
                Expression exp = parser.parseExpression(condition.get());
                return exp.getValue(userAgentObject.get(), Boolean.class);
            } catch (ExpressionException e) {
                logger.error("Failed to parse or evaluate expression. Condition: {} User-agent: {} {}",
                        condition.get(), userAgentObject.get(), e);
                return false;
            }
        } else {
            return true;
        }
    }
}
