package ru.yandex.chemodan.app.uaas.parser;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.uaas.test.UaasTestContextConfiguration;
import ru.yandex.misc.test.Assert;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {
        UaasTestContextConfiguration.class,
        UaasParserContextConfiguration.class,
})
public class UaasConditionParserTest {

    @Autowired
    private UaasConditionParser parser;

    @Test
    public void testParse() {
        UserAgentObject userAgentObject = UserAgentObject.builder().version(Version.of("8.0.133-999")).build();
//        UserAgentObject userAgentExperimentCondition2 = UserAgentObject.builder().build();
        String condition = "(version > '8.0.133-998')";
        final Boolean parse = parser.validate(Option.of(condition), Option.of(userAgentObject));
        Assert.assertTrue(parse);
    }
}
