package ru.yandex.chemodan.app.uaas.parser;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.parse.BenderJsonParser;
import ru.yandex.misc.lang.StringUtils;

public class UserAgentParser {
    private static final BenderJsonParser<UserAgentObject> userAgentObjectParser = Bender.jsonParser(UserAgentObject.class);

    public Option<UserAgentObject> parse(Option<String> userAgentString) {
        if (userAgentString.isPresent()) {
            String jsonPart = StringUtils.substringAfter(userAgentString.get(), "Yandex.Disk ");
            try {
                UserAgentObject userAgentObject = userAgentObjectParser.parseJson(jsonPart);
                userAgentObject.setVersion(Version.of(userAgentObject.vsn));
                return Option.of(userAgentObject);
            } catch (Exception e) {
                return Option.empty();
            }
        }
        return Option.empty();
    }


}
